VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "AppSentinelAdmin Example"
   ClientHeight    =   2565
   ClientLeft      =   4620
   ClientTop       =   2520
   ClientWidth     =   5715
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2565
   ScaleWidth      =   5715
   Begin VB.CommandButton cmdCalc 
      Caption         =   "Calculate Evaluation ID"
      Height          =   615
      Index           =   1
      Left            =   3450
      Style           =   1  'Graphical
      TabIndex        =   4
      ToolTipText     =   " Calculate an Evaluation ID "
      Top             =   1725
      Width           =   1215
   End
   Begin VB.CommandButton cmdCalc 
      Caption         =   "Calculate Registration ID"
      Height          =   615
      Index           =   0
      Left            =   1725
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   " Calculate a Registration ID "
      Top             =   1725
      Width           =   1215
   End
   Begin VB.TextBox txtRID 
      ForeColor       =   &H80000012&
      Height          =   285
      Left            =   1395
      TabIndex        =   2
      ToolTipText     =   " Enter the Registration ID "
      Top             =   1215
      Width           =   3975
   End
   Begin VB.TextBox txtMID 
      ForeColor       =   &H80000012&
      Height          =   285
      Left            =   1395
      TabIndex        =   1
      ToolTipText     =   " Enter the Machine ID"
      Top             =   720
      Width           =   3975
   End
   Begin VB.TextBox txtEID 
      ForeColor       =   &H80000012&
      Height          =   285
      Left            =   1395
      TabIndex        =   0
      ToolTipText     =   " Enter the Evaluation ID "
      Top             =   225
      Width           =   3975
   End
   Begin VB.Label lblMID 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Machine ID:"
      Height          =   255
      Left            =   75
      TabIndex        =   7
      Top             =   750
      Width           =   1215
   End
   Begin VB.Label lblEID 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Evaluation ID:"
      Height          =   255
      Left            =   315
      TabIndex        =   6
      Top             =   270
      Width           =   1020
   End
   Begin VB.Label lblRID 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Registration ID:"
      Height          =   255
      Left            =   195
      TabIndex        =   5
      Top             =   1245
      Width           =   1125
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' Copyright  2002 David Scarmozzino
'      All Rights Reserved
'    http://www.TheScarms.com
'         TheScarms (TM)
'
' This source code may not be redistributed. Redistributing
' thiss ource code is a violation of copyright laws.
'
' This sample program was designed to serve as an example
' of calling the various methods of the AppSentinelAdmin DLL.
'
' It is not intended to be used "as is" in your production
' application. The actual logic and sequence of DLL method
' calls must be designed to suit your specific needs.
'

'
' Create a variable to reference the AppSentinelAdmin object.
'
' To use late binding uncomment this line.
Private mobjAdmin As Object
'
' To use early binding reference "TheScarms AppSentinelAdminT" or
' "TheScarms AppSentinelAdmin" under Project | References and
' uncomment the corresponding line:
'
'Private mobjAdmin As New AppSentinelAdmin.Admin
'Private mobjAdmin As New AppSentinelAdminT.Admin
'
' Maximum ID length
'
Private Const cIDLength = 36
Private Sub cmdCalc_Click(Index As Integer)
Dim strRID   As String
Dim strEID   As String
Dim strMID   As String
Dim strError As String

    '
    '-----------------------------------------------------------------------
    ' Calculate a Registration or Evaluation ID.
    '-----------------------------------------------------------------------
    '
    On Error GoTo ErrorHandler
    
    ' Get input values.
    strRID = Trim$(txtRID.Text)
    strEID = Trim$(txtEID.Text)
    strMID = UCase$(Trim$(txtMID.Text))
    
    ' Verify required fields.
    Select Case Index
        Case 0 'Calculate Registration ID
            ' Verify the evaluation ID.
            If strEID = "" Then
                Call MsgBox("An Evaluation ID is required to calculate the Registration ID.", vbExclamation, "Missing Information")
                txtEID.SetFocus
                GoTo NormalExit
            End If
        
            If Not mobjAdmin.ValidateEvaluationID(strEID, strError) Then
                Call MsgBox(strError, vbExclamation, "Invalid Evaluation ID")
                txtEID.SetFocus
                GoTo NormalExit
            End If
            
            ' Verify the Machine ID.
            If strMID = "" Then
                Call MsgBox("A Machine ID is required to calculate the Registration ID.", vbExclamation, "Missing Information")
                txtMID.SetFocus
                GoTo NormalExit
            End If
            
            If Not mobjAdmin.ValidateMachineID(strMID, strError) Then
                Call MsgBox(strError, vbExclamation, "Invalid Machine ID")
                txtMID.SetFocus
                GoTo NormalExit
            End If
        
            ' Calculate registration ID.
            txtRID.Text = mobjAdmin.CalculateRegistrationID(strEID, strMID, strError)
            txtRID.SetFocus
                
        Case 1 'Calculate Evaluation ID
            ' Verify the Machine ID.
            If strMID = "" Then
                Call MsgBox("A Machine ID is required to calculate the Evaluation ID.", vbExclamation, "Missing Information")
                txtMID.SetFocus
                GoTo NormalExit
            End If
        
            If Not mobjAdmin.ValidateMachineID(strMID, strError) Then
                Call MsgBox(strError, vbExclamation, "Invalid Machine ID")
                txtMID.SetFocus
                GoTo NormalExit
            End If
            
            ' Verify the registration ID.
            If strRID = "" Then
                Call MsgBox("A Registration ID is required to calculate the Evaluation ID.", vbExclamation, "Missing Information")
                txtRID.SetFocus
                GoTo NormalExit
            End If
            
            If Not mobjAdmin.ValidateRegistrationID(strRID, strError) Then
                Call MsgBox(strError, vbExclamation, "Invalid Registration ID")
                txtRID.SetFocus
                GoTo NormalExit
            End If
            
            ' Calculate evaluation ID.
            txtEID.Text = mobjAdmin.CalculateEvaluationID(strRID, strMID, strError)
            txtEID.SetFocus
    End Select

    GoTo NormalExit

ErrorHandler:
    If strError = "" Then strError = Err.Description
    Call MsgBox(strError, vbCritical, "Error")

NormalExit:
End Sub
Private Sub Form_Load()
Dim lngResult As Long
Dim strError  As String

    ' Only allow 1 instance.
    If App.PrevInstance Then End
    With Me
        .Left = (Screen.Width - .Width) / 2
        .Top = ((Screen.Height - .Height) / 2)
    End With
    
    ' Instantiate AppSentinelAdmin.
    ' Comment out these lines when using early binding.
    'Set mobjAdmin = CreateObject("AppSentinelAdmin.Admin")
    Set mobjAdmin = CreateObject("AppSentinelAdminT.Admin")

    ' Set the textbox length properties.
    txtEID.MaxLength = cIDLength
    txtRID.MaxLength = cIDLength
    txtMID.MaxLength = cIDLength

    ' Your normal Form_Load code goes here.
    
End Sub

Private Sub Form_Unload(Cancel As Integer)

    ' You should always do this.
    Set mobjAdmin = Nothing
    Set frmMain = Nothing

End Sub
Private Sub txtEID_KeyPress(KeyAscii As Integer)

    ' Limit input to valid Evaluation ID values.
    ' Optional - Admin functions will validate.
    Select Case KeyAscii
        Case Asc(vbCr) 'Enter key
            KeyAscii = 0
            
        Case 8, 45, 48 To 57, 65 To 70
            
        ' Everything else
        Case Else
            KeyAscii = 0
    End Select

End Sub
Private Sub txtMID_KeyPress(KeyAscii As Integer)

    ' Limit input to valid Machine ID values.
    ' Optional - Admin functions will validate.
    Select Case KeyAscii
        Case Asc(vbCr) 'Enter key
            KeyAscii = 0
            
        Case 8, 48 To 57, 65 To 90
        
        ' Everything else
        Case Else
            KeyAscii = 0
    End Select

End Sub
Private Sub txtRID_KeyPress(KeyAscii As Integer)

    ' Limit input to valid Registration ID values.
    ' Optional - Admin functions will validate.
    Select Case KeyAscii
        Case Asc(vbCr) 'Enter key
            KeyAscii = 0
            
        Case 8, 45, 48 To 57, 65 To 90, 97 To 119
            
        ' Everything else
        Case Else
            KeyAscii = 0
    End Select

End Sub
